<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

use ActiveRecord\Base;

/**
 * AccountRelation.
 *
 * Questo modello è legato alla tabella `users_relations` e serve come supporto al modello `Account` per la gestione
 * della portafogliazione. Rappresenta una relazione diretta tra padre e figlio.
 *
 * @property int $id
 * @property int $parent_id
 * @property int $child_id
 */
class AccountRelation extends Base
{
    /**
     * Nome della tabella.
     *
     * @static
     * @var string
     */
    public static $table_name = 'users_relations';
}
