<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Mailer\Transport;

/**
 * AuthSmtpTransport
 *
 * @method \Swift_SmtpTransport setUsername(string $username) Set the username to authenticate with.
 * @method string               getUsername()                 Get the username to authenticate with.
 * @method \Swift_SmtpTransport setPassword(string $password) Set the password to authenticate with.
 * @method string               getPassword()                 Get the password to authenticate with.
 * @method \Swift_SmtpTransport setAuthMode(string $mode)     Set the auth mode to use to authenticate.
 * @method string               getAuthMode()                 Get the auth mode to use to authenticate.
 */
class AuthSmtpTransport extends \Swift_Transport_EsmtpTransport
{
    /**
     * @param string $username
     * @param string $password
     * @param string $host
     * @param int    $port
     * @param string $security
     */
    public function __construct($username, $password, $host = 'localhost', $port = 25, $security = null)
    {
        call_user_func_array(
            array($this, 'Swift_Transport_EsmtpTransport::__construct'),
            \Swift_DependencyContainer::getInstance()
                ->createDependenciesFor('transport.smtp')
        );

        $this->setUsername($username);
        $this->setPassword($password);
        $this->setHost($host);
        $this->setPort($port);
        $this->setEncryption($security);
    }

    /**
     * @param string $username
     * @param string $password
     * @param string $host
     * @param int    $port
     * @param string $security
     * @return AuthSmtpTransport
     */
    public static function newInstance($username, $password, $host = 'localhost', $port = 25, $security = null)
    {
        return new self($username, $password, $host, $port, $security);
    }
}
