<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core;

require __DIR__ . '/functions.php';

use Application\Core\DependencyInjection\DashboardServiceProvider;
use Application\Core\DependencyInjection\SdkServiceProvider;
use Pongho\Core\Plugin;

/**
 * Kernel dell’applicazione.
 */
class Kernel extends Plugin
{
    /**
     * Indica la versione dell’applicazione.
     */
    const VERSION = '1.0.0-dev';

    /**
     * {@inheritdoc}
     */
    public function setUp()
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function load()
    {
        // Info: I servizi del Core sono registrati in AppKernel::registerComponents()

        $this->container->register(new DashboardServiceProvider());
        $this->container->register(new SdkServiceProvider());
    }

    /**
     * {@inheritdoc}
     */
    public function install()
    {
    }

    /**
     * {@inheritdoc}
     */
    public function uninstall()
    {
    }

    /**
     * {@inheritdoc}
     */
    public function enable()
    {
    }

    /**
     * {@inheritdoc}
     */
    public function disable()
    {
    }
}
