<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Installer\Helper;

use Doctrine\DBAL\Connection;

/**
 * TranslationsHelper
 */
class TranslationsHelper
{
    /**
     * @var Connection
     */
    protected $connection;

    /**
     * @var array
     */
    protected $languages_sites;

    /**
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }

    /**
     * @param int $language_site_id
     */
    public function setLanguageSite($language_site_id)
    {
        trigger_error(sprintf('Il metodo %s non è testato.', __METHOD__), E_USER_NOTICE);

        $this->languages_sites = [$language_site_id];
    }

    /**
     * @param int $language_id
     * @param int $site_id
     */
    public function setLanguageAndSite($language_id, $site_id)
    {
        trigger_error(sprintf('Il metodo %s non è testato.', __METHOD__), E_USER_NOTICE);

        $this->setLanguagesSites(function () use ($language_id, $site_id) {
            $sth = $this->connection->prepare(
                'SELECT id FROM pongho_languages_sites WHERE language_id = :language AND site_id = :site'
            );

            $sth->execute([
                'language' => $language_id,
                'site'     => $site_id,
            ]);

            return $sth;
        });
    }

    /**
     * @param string $culture
     */
    public function setCulture($culture)
    {
        $this->setLanguagesSites(function () use ($culture) {
            $sth = $this->connection->prepare(
                'SELECT ls.id FROM pongho_languages_sites AS ls INNER JOIN pongho_languages AS l ON l.id = ls.language_id WHERE l.culture = :culture'
            );

            $sth->execute([
                'culture' => $culture,
            ]);

            return $sth;
        });
    }

    /**
     * @param int $language_id
     */
    public function setLanguage($language_id)
    {
        trigger_error(sprintf('Il metodo %s non è testato.', __METHOD__), E_USER_NOTICE);

        $this->setLanguagesSites(function () use ($language_id) {
            $sth = $this->connection->prepare(
                'SELECT id FROM pongho_languages_sites WHERE language_id = :language'
            );

            $sth->execute([
                'language' => $language_id,
            ]);

            return $sth;
        });
    }

    /**
     * @param int $site_id
     */
    public function setSite($site_id)
    {
        trigger_error(sprintf('Il metodo %s non è testato.', __METHOD__), E_USER_NOTICE);

        $this->setLanguagesSites(function () use ($site_id) {
            $sth = $this->connection->prepare(
                'SELECT id FROM pongho_languages_sites WHERE site_id = :site'
            );

            $sth->execute([
                'site' => $site_id,
            ]);

            return $sth;
        });
    }

    /**
     * @param string $key
     * @param string $value
     * @param string $application
     */
    public function addOrChangeTranslation($key, $value, $application)
    {
        trigger_error(sprintf('Il metodo %s non è testato.', __METHOD__), E_USER_NOTICE);

        if ($this->exists($key)) {
            $this->changeTranslation($key, $value);
        } else {
            $this->addTranslation($key, $value, $application);
        }
    }

    /**
     * @param string $key
     * @param string $value
     * @param string $application
     */
    public function addTranslation($key, $value, $application)
    {
        $key_field_name = $this->connection->getDatabasePlatform()->quoteIdentifier('key');

        $this->exec(function ($language_site_id) use ($key, $value, $application, $key_field_name) {
            $this->connection->insert(
                'pongho_translations',
                [
                    $key_field_name    => $key,
                    'language_site_id' => $language_site_id,
                    'application'      => $application,
                    'value'            => $value,
                ],
                [
                    $key_field_name    => \PDO::PARAM_STR,
                    'language_site_id' => \PDO::PARAM_INT,
                    'application'      => \PDO::PARAM_STR,
                    'value'            => \PDO::PARAM_STR,
                ]
            );
        });
    }

    /**
     * @param string $key
     * @param string $value
     */
    public function changeTranslation($key, $value)
    {
        trigger_error(sprintf('Il metodo %s non è testato.', __METHOD__), E_USER_NOTICE);

        $key_field_name = $this->connection->getDatabasePlatform()->quoteIdentifier('key');

        $this->exec(function ($language_site_id) use ($key, $value, $key_field_name) {
            $this->connection->update(
                'pongho_translations',
                [
                    'value'            => $value,
                ],
                [
                    $key_field_name    => $key,
                    'language_site_id' => $language_site_id,
                ],
                [
                    $key_field_name    => \PDO::PARAM_STR,
                    'language_site_id' => \PDO::PARAM_INT,
                    'application'      => \PDO::PARAM_STR,
                    'value'            => \PDO::PARAM_STR,
                ]
            );
        });
    }

    /**
     * @param string $old_key
     * @param string $new_key
     */
    public function changeKey($old_key, $new_key)
    {
        trigger_error(sprintf('Il metodo %s non è ancora stato sviluppato.', __METHOD__), E_USER_ERROR);
    }

    /**
     * @param string $key
     * @param string $application
     */
    public function changeApplication($key, $application)
    {
        trigger_error(sprintf('Il metodo %s non è ancora stato sviluppato.', __METHOD__), E_USER_ERROR);
    }

    /**
     * @param string $key
     * @return bool
     */
    public function exists($key)
    {
        trigger_error(sprintf('Il metodo %s non è ancora stato sviluppato.', __METHOD__), E_USER_ERROR);
    }

    public function removeTranslation($key)
    {
        $key_field_name = $this->connection->getDatabasePlatform()->quoteIdentifier('key');

        $this->connection->delete(
            'pongho_translations',
            [
                $key_field_name => $key,
            ],
            [
                $key_field_name => \PDO::PARAM_STR,
            ]
        );
    }

    protected function exec(callable $callable)
    {
        foreach ($this->languages_sites as $language_site_id) {
            call_user_func($callable, $language_site_id);
        }
    }

    /**
     * @param callable $callable
     */
    protected function setLanguagesSites(callable $callable)
    {
        $this->languages_sites = [];

        $sth = call_user_func($callable);

        while ($id = $sth->fetchColumn()) {
            $this->languages_sites[] = $id;
        }
    }
}
