<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Installer\Helper;

use Doctrine\DBAL\Connection;

/**
 * PermissionsHelper
 */
class PermissionsHelper
{
    /**
     * @var Connection
     */
    protected $connection;

    /**
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }

    /**
     * @param string $name
     * @param bool   $is_enabled
     */
    public function addPermission($name, $is_enabled = true)
    {
        $this->addPermissions([$name], $is_enabled);
    }

    /**
     * @param array $keys
     * @param bool  $is_enabled
     */
    public function addPermissions(array $keys, $is_enabled = true)
    {
        $key_field_name = $this->connection->getDatabasePlatform()->quoteIdentifier('key');

        $placeholders = substr(str_repeat('?, ', count($keys)), 0, -2);
        $stm = "SELECT * FROM pongho_permits WHERE {$key_field_name} IN ({$placeholders})";

        $sth = $this->connection->prepare($stm);
        $sth->execute($keys);

        $permissions = [];
        while ($row = $sth->fetch()) {
            $permissions[$row['key']] = $row;
        }

        foreach ($keys as $key) {
            if (!isset($permissions[$key])) {
                $this->connection->insert(
                    'pongho_permits',
                    [
                        $key_field_name => $key,
                        'is_enabled'    => $is_enabled,
                    ],
                    [
                        $key_field_name => \PDO::PARAM_STR,
                        'is_enabled'    => \PDO::PARAM_BOOL,
                    ]
                );
            } elseif ($permissions[$key]['is_enabled'] !== $is_enabled) {
                $this->connection->update(
                    'pongho_permits',
                    [
                        'is_enabled' => $is_enabled,
                    ],
                    [
                        'id' => $row['id'],
                    ],
                    [
                        'id'         => \PDO::PARAM_INT,
                        'is_enabled' => \PDO::PARAM_BOOL,
                    ]
                );
            }
        }
    }

    /**
     * @param string $name
     */
    public function removePermission($name)
    {
        $this->removePermissions([$name]);
    }

    /**
     * @param array $keys
     */
    public function removePermissions(array $keys)
    {
        $key_field_name = $this->connection->getDatabasePlatform()->quoteIdentifier('key');

        $placeholders = substr(str_repeat('?, ', count($keys)), 0, -2);
        $stm = "DELETE FROM pongho_permits WHERE {$key_field_name} IN ({$placeholders})";

        $sth = $this->connection->prepare($stm);
        $sth->execute($keys);
    }
}
