<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\I18n\Translation\Loader;

use Symfony\Component\Translation\Loader\XliffFileLoader;

/**
 * PonghoAppLoader
 */
class PonghoAppLoader extends XliffFileLoader
{
    /**
     * {@inheritdoc}
     */
    public function load($resource, $locale, $domain = 'messages')
    {
        return parent::load(
            PONGHO_PATH . '/Application/' . ucfirst($resource) . '/Resources/translations/' . $domain . '.' . str_replace('_', '-', $locale) . '.xlf',
            $locale,
            $domain
        );
    }
}
