<?php

namespace Application\Core\Form;

use Application\Admin\Form\SelectField;
use Application\Core\Model\Role;

class RoleField extends SelectField
{
	/**
	 * @inherits
	 */
	protected function setItems()
	{
		if ( $this->items === null )
		{
			$roles = Role::all(array(
				'conditions'	=> array('id <> ?', Role::USER_NOT_LOGGED)
			));

			foreach ( $roles as $role )
			{
				$this->items[$role->id] = $role->name;
			}
		}
	}
}