<?php

namespace Application\Core\Form\Field;

use Application\Core\Model\Role;
use Pongho\Form\Field\SelectField;

/**
 * RoleField
 *
 * @deprecated
 */
class RoleField extends SelectField
{
	protected $value_type = 'id';

    /**
     * Imposta il tipo di valore da utilizzare per la select dei ruoli
     *
     * @access public
     * @param string $value_type //[id]
     * @throws \InvalidArgumentException
     * @return $this
     */
	public function setValueType($value_type)
	{
		if ( !in_array($value_type, array('id')) )
		{
			throw new \InvalidArgumentException(sprintf('Value type "%s" is not valid', $value_type));
		}

		$this->value_type = $value_type;

		return $this;
	}

	/**
	 * Restituisce il tipo di valore utilizzato per la select delle regioni
	 *
	 * @access public
	 * @return string
	 */
	public function getValueType()
	{
		return $this->value_type;
	}

	/**
	 * Imposta le opzioni della select
	 *
	 * @access public
	 * @throws \BadMethodCallException
	 */
	public function setOptions($options)
	{
		throw new \BadMethodCallException('You could\'t override the regions!');
	}

	/**
	 * Restituisce le opzioni della select
	 *
	 * @access public
	 * @return array
	 */
	public function getOptions()
	{
		if ( empty($this->options) )
		{
			foreach ( Role::all(array('conditions' => array('id <> ?', Role::USER_NOT_LOGGED))) as $role )
			{
				$this->options[$role->{$this->value_type}] = $role->name;
			}
		}

		return $this->options;
	}
}
