<?php

namespace Application\Core\Form\Field;

use Pongho\Form\BaseField;

class AccountUrlField extends BaseField
{
    public function isReadonly()
    {
        return true;
    }

    /**
     * @return string
     */
    public function getTag()
    {
        $url_part = sprintf(
            '<span class="url-editor-path">%s</span><span class="url-editor-slug">%s</span>',
            $this->getSetting('url-path', ''),
            html_escape($this->getValue())
        );

        $btn_part = '';
        if (!$this->getSetting('disable-edit', false)) {
            $btn_part = sprintf(
                '<button type="button" id="%s" data-form="%s" title="%s" class="pongho-button url-editor-btn">%s</button>',
                $this->getId() . '-btn',
                $this->getSetting('form-url'),
                $this->getSetting('lightbox-title'),
                $this->getSetting('button-value')
            );
        }

        return '<div id="' . $this->getId() . '" class="url-editor">' . $url_part . $btn_part . '</div>';
    }

    /**
     * Restituisce il valore di default nel caso il campo non sia stato passato nella request perché non selezionato (es checkbox o select multiple)
     *
     * @access public
     * @return mixed
     */
    public function emptyValue()
    {
        return '';
    }

    /**
     * {@inheritdoc}
     */
    public function setBaseAttributes()
    {
        $this->setAttribute('id', $this->getId());

        return $this;
    }

    public function getValidAttributes()
    {
        return array('id', 'class', 'style');
    }
}
