<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Admin\AdminSidebar\Sidebar;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

/**
 * Class AdminSidebarServiceProvider
 */
class AdminSidebarServiceProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->extend('admin_sidebar', array($this, 'addSidebarItems'));
    }

    /**
     * Aggiunge elementi alla sidebar di Pongho.
     *
     * @param Sidebar   $sidebar
     * @param Container $container
     *
     * @internal
     */
    public function addSidebarItems(Sidebar $sidebar, Container $container)
    {
        /** @var \Application\Core\I18n\Translation\Translator $translator */
        $translator = $container->get('translator');

        /** @var \Application\Core\User $user */
        $user = $container->get('current_user');

        if ($user->hasPermit('users.admin')) {
            $sidebar->addPanel($translator->trans('Users'), 'users', 'users', Sidebar::POS_BOTTOM);
            $sidebar->addItem(
                $translator->trans('List'),
                '/users/',
                'users',
                Sidebar::POS_PANEL_ACTIONS,
                'Application\Core\Controller\Admin\UsersController'
            );

            if ($user->hasPermit('users.add')) {
                $sidebar->addItem(
                    $translator->trans('Add'),
                    '/users/add/',
                    'users',
                    Sidebar::POS_PANEL_ACTIONS,
                    'Application\Core\Controller\Admin\UsersController'
                );
            }

            if ($user->hasPermit('users.handle_roles')) {
                $sidebar->addItem(
                    $translator->trans('Roles'),
                    '/roles/',
                    'users',
                    Sidebar::POS_PANEL_FEATURES,
                    'Application\Core\Controller\Admin\RolesController'
                );
            }

            if ($user->hasPermit('users.handle_groups')) {
                $sidebar->addItem(
                    $translator->trans('Groups'),
                    '/groups/',
                    'users',
                    Sidebar::POS_PANEL_FEATURES,
                    'Application\Core\Controller\Admin\GroupsController'
                );
            }

            if ($user->isFounder()) {
                $sidebar->addItem(
                    $translator->trans('Import users'),
                    '/users-import/',
                    'users',
                    Sidebar::POS_PANEL_SETTINGS,
                    'Application\Core\Controller\Admin\UsersImportController'
                );
            }
        }

        if ($user->hasPermit('admin.options')) {
            if ($user->hasPermit('admin.options.translations')) {
                $sidebar->addItem(
                    $translator->trans('Translations configuration'),
                    '/translations/',
                    'options',
                    Sidebar::POS_PANEL_FEATURES,
                    'Application\Core\Controller\Admin\TranslationsController'
                );
            }

            if ($user->hasPermit('admin.options.notifications')) {
                $sidebar->addItem(
                    $translator->trans('Notification templates'),
                    '/notifications/',
                    'options',
                    Sidebar::POS_PANEL_SETTINGS,
                    'Application\Core\Controller\Admin\NotificationsTemplatesController'
                );
            }
        }

        if ($user->isFounder()) {
            $sidebar->addItem(
                $translator->trans('Site configuration'),
                '/settings/',
                'settings',
                Sidebar::POS_PANEL_FEATURES,
                'Application\Core\Controller\Admin\SettingsController'
            );
            $sidebar->addItem(
                $translator->trans('Languages configuration'),
                '/languages/',
                'settings',
                Sidebar::POS_PANEL_FEATURES,
                'Application\Core\Controller\Admin\LanguagesController'
            );
            $sidebar->addItem(
                $translator->trans('Permits'),
                '/permits/',
                'settings',
                Sidebar::POS_PANEL_FEATURES,
                'Application\Core\Controller\Admin\PermitsController'
            );
            $sidebar->addItem(
                $translator->trans('Applications configuration'),
                '/apps/',
                'settings',
                Sidebar::POS_PANEL_FEATURES,
                'Application\Core\Controller\Admin\AppsController'
            );
        }

        // Rotte per la gestione del multisito e dei widget in bacheca.
        $sidebar->addRoute('/sites/', 'Application\\Core\\Controller\\Admin\\SitesController');
    }
}
