<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

/**
 * Class AddressProvider
 *
 * Provider per la generazione e la validazione degli indirizzi I18n
 */
class AddressProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->share('italy_address_validator', array($this, 'getItalyAddressValidatorService'));
        $container->share('italy_address_renderer', array($this, 'getItalyAddressRendererService'));
    }

    /**
     * getItalyAddressValidatorService
     *
     * @param Container $container
     * @return \Application\Core\I18n\Country\Italy\AddressValidator
     *
     * @internal
     */
    public function getItalyAddressValidatorService(Container $container)
    {
        if ($container->hasParameter('italy_address_validator_class')) {
            $class = $container->getParameter('italy_address_validator_class');
        } else {
            $class = 'Application\\Core\\I18n\\Country\\Italy\\AddressValidator';
        }

        return new $class();
    }

    /**
     * getItalyAddressRendererService
     *
     * @param Container $container
     * @return \Application\Core\I18n\Country\Italy\AddressRenderer
     *
     * @internal
     */
    public function getItalyAddressRendererService(Container $container)
    {
        if ($container->hasParameter('italy_address_renderer_class')) {
            $class = $container->getParameter('italy_address_renderer_class');
        } else {
            $class = 'Application\\Core\\I18n\\Country\\Italy\\AddressRenderer';
        }

        return new $class();
    }
}
