<?php

/**
 * Questo file è parte di Pongho 2.0-dev.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Controller\Admin;

use Application\Admin\Controller\CrudFormController;
use Application\Admin\Form\FormConfig;
use Application\Core\Model\Permit;
use Pongho\Form\Subject\ModelSubject;

/**
 * Class PermitsController
 */
class PermitsController extends CrudFormController
{
    /**
     * {@inheritdoc}
     */
    function getNamespace()
    {
        return 'permits';
    }

    /**
     * {@inheritdoc}
     */
    function getEventNamespace($event_name)
    {
        return 'admin.permits.' . $event_name;
    }

    /**
     * {@inheritdoc}
     */
    protected function getArchiveTitle()
    {
        return $this->getContainer()->get('translator')->trans('Permits list');
    }

    /**
     * {@inheritdoc}
     */
    public function getArchiveAddButtonText()
    {
        return $this->getContainer()->get('translator')->trans('Add a new permit');
    }

    /**
     * {@inheritdoc}
     */
    public function hasAddButton()
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    protected function getArchiveAddFirstText()
    {
        return $this->getContainer()->get('translator')->trans('Add the first permit');
    }

    /**
     * {@inheritdoc}
     */
    public function getModelClass()
    {
        return 'Application\\Core\\Model\\Permit';
    }

    /**
     * {@inheritdoc}
     */
    public function getAddEditTitle($model)
    {
        /** @var \Application\Core\I18n\Translation\Translator $translator */
        $translator = $this->getContainer()->get('translator');

        if ($model->isNewRecord()) {
            return $translator->trans('Add permit');
        }

        return $translator->trans('Edit the permit “%title%”', array(
                '%title%' => $this->getHelper()->getLocalization()->get('permit_' . $model->key)
            )
        );
    }

    /**
     * {@inheritdoc}
     */
    protected function getTableColumns()
    {
        /** @var \Application\Core\I18n\Translation\Translator $translator */
        $translator = $this->getContainer()->get('translator');

        $lang = $this->getHelper()->getLocalization();

        return array(
            array(
                'name'      => 'key',
                'label'     => $translator->trans('Permit'),
                'class'     => 'main',
                'orderable' => true,
                'render'    => function (Permit $row) use ($lang) {
                        // todo: usare translator quando le traduzioni per i nomi dei permessi verranno gestite con una tabella apposita
                        return '<strong>' . $lang->get('permit_' . $row->key) . '</strong><div class="actions"><span>' . $row->actions . '</span></div>';
                    },
            ),
            array(
                'name'      => 'is_enabled',
                'label'     => $translator->trans('Is enabled'),
                'class'     => 'large',
                'orderable' => true,
                'render'    => function (Permit $row) use ($translator) {
                        return $row->is_enabled ? $translator->trans('Yes') : $translator->trans('No');
                    },
            ),
        );
    }

    /**
     * @return ModelSubject
     */
    public function getSubject()
    {
        return new ModelSubject($this->getModel());
    }

    /**
     * {@inheritdoc}
     */
    public function getFormsOptions()
    {
        $subject = $this->getSubject();

        /** @var \Application\Core\I18n\Translation\Translator $translator */
        $translator = $this->getContainer()->get('translator');

        $options = new FormConfig('permits', $subject, $this->getHelper()->getLocalization());

        $options->addBaseStructure('main', $this->currentUrl());
        $options->addTab('content/main', $translator->trans('Main'));
        $options->addPanel('content/main/permit-panel');

        $options->addFields(
            'content/main/permit-panel',
            array(
                'key' => array(
                    'class' => 'Pongho\\Form\\Field\\TextField',
                    'label' => $translator->trans('Permit key'),
                ),
                'is_enabled' => array(
                    'class' => 'Pongho\\Form\\Field\\CheckboxField',
                    'label' => $translator->trans('Is enabled'),
                ),
            )
        );


        $options = $this->getHelper()->filter($this, $this->getEventNamespace('filter_form_options'), $options, array('subject' => $subject));

        return $options;
    }

    /**
     * {@inheritdoc}
     */
    protected function getModelFieldsConfig()
    {
        /** @var \Application\Core\I18n\Translation\Translator $translator */
        $translator = $this->getContainer()->get('translator');

        return array(
            'key'        => array(
                'label' => $translator->trans('Permit key'),
            ),
            'is_enabled' => array(
                'label' => $translator->trans('Is enabled'),
            ),
        );
    }

    /**
     * {@inheritdoc}
     */
    protected function getFilterEnumValues()
    {
        /** @var \Application\Core\I18n\Translation\Translator $translator */
        $translator = $this->getContainer()->get('translator');

        $boolean = array(
            '0' => $translator->trans('No'),
            '1' => $translator->trans('Yes'),
        );

        return array(
            'is_enabled'  => $boolean,
        );
    }
}
