<?php

namespace Application\Core\Controller\Admin\LinkField;

use Application\Core\Model\LanguageModule;
use Application\Core\Model\LanguageSite;
use Application\Core\Model\LinkType;
use Application\Core\Model\Module;
use Application\Core\Model\ModuleSite;
use Pongho\Core\Kernel;
//use Pongho\Menu\Item;

class ModuleHandler extends \Application\Admin\Form\LinkField\BaseHandler
{
	private $modules = array();

    public function getClass($type = '')
    {
        return get_class($this) . '::module' . $type;
    }

	public function addTypesOptions($language_id, array $options)
	{
		foreach ( $this->getModules($language_id) as $module )
		{
			if ( $language_id === null )
			{
				$options[$module->language_id][$this->getClass('_' . $module->language_id)] = 'module';
			}
			else
			{
				$options[$this->getClass()] = 'module';
			}
		}

		return $options;
	}

	public function render($name, $language_id, LinkType $link_type = null)
	{
		$blocks = array();
		$html = Kernel::instance()->getContainer()->get('template_html');

		foreach ( $this->getModules($language_id) as $module )
		{
            $key = 'module_' . ($language_id === null ? $module->language_id : $language_id);
			$language = $language_id === null ? $module->language_id : $language_id;
			$field_name = $name . '[' . $key . ']';

			$blocks[$key] = '<select name="' . $field_name . '">' . $html->select($this->getModulesNames($language), ($link_type === null ? null : $link_type->model_id)) . '</select>';
		}

		return $blocks;
	}

    public function renderSpan($name, $language_id, LinkType $link_type = null)
    {
        $blocks = array();

        foreach ($this->getModules($language_id) as $module) {
            $key = 'module_' . $module->language_id;
            $language = $language_id === null ? $module->language_id : $language_id;
            $field_name = $name . '[' . $key . ']';

            $blocks[$key] = '<span data-name="' . $field_name . '" data-value="' . ($link_type === null ? '' : $link_type->model_id) . '" data-language="' . $language . '"></span>';
        }

        return $blocks;
    }

    public function getSelectOptions($language_id, array $query_options = array())
    {
        $blocks = array();
        $html = Kernel::instance()->getContainer()->get('template_html');

        foreach ($this->getModules($language_id) as $module) {
            $key = 'module_' . ($language_id === null ? $module->language_id : $language_id);
            $language = $language_id === null ? $module->language_id : $language_id;

            $blocks[$key] = $html->select($this->getModulesNames($language));
        }

        return $blocks;
    }


    private function getModules($language_id)
	{
		if ( !array_key_exists($language_id, $this->modules) )
		{
			$modules = array();

			if ( $language_id === null )
			{
				$options = array(
					'select'		=> 'm.*, ls.*, lm.*, `from`.*',
                    'joins'			=> 'INNER JOIN ' . Module::table_name() . ' AS m ON m.id = `from`.module_id'
                                    . ' INNER JOIN ' . LanguageSite::table_name() . ' AS ls ON ls.site_id = `from`.site_id'
                                    . ' INNER JOIN ' . LanguageModule::table_name() . ' AS lm ON lm.module_id = `from`.module_id AND lm.language_site_id = ls.id',
                    'conditions'    => array(
                        '`from`.site_id = :site AND `from`.is_enabled = :enabled AND ls.is_enabled = :enabled',
                        'site'    => $this->site_id,
                        'enabled' => true,
                    ),
                );

				$this->modules[null] = ModuleSite::all($options);
			}
			else
			{
				$this->modules[$language_id] = ModuleSite::findAll($this->site_id, $language_id);
			}
		}

		return $this->modules[$language_id];
	}

	private function getModulesNames($language_id)
	{
		$modules = array();
		foreach ( $this->getModules($language_id) as $module)
		{
			if ( !isset($module->language_id) || ($module->language_id === $language_id) )
			{
				$modules[$module->id] = $module->name;
			}
		}

		return $modules;
	}

	public static function parseAttributes(array $attributes)
	{
		$key = isset($attributes['key']) ? $attributes['key'] : $attributes['link_type'];

		if ( array_key_exists($key, $attributes) )
		{
			$attributes['model_id'] = $attributes[$key];

			$language_module = LanguageModule::findByLanguageAndSiteAndModule($attributes['language_id'], $attributes['site_id'], $attributes[$key]);

			if ( $language_module !== null )
			{
				$attributes['model_path'] = $language_module->path;
			}
		}

		return $attributes;
	}
}
