<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Application;

use Application\Core\Model\Manager\ApplicationManagerInterface;
use Pongho\DependencyInjection\Container;

/**
 * CliLoader
 */
class CliLoader extends AbstractLoader
{
    /**
     * @var ApplicationManagerInterface
     */
    protected $manager;

    /**
     * @param Container                   $container
     * @param ApplicationManagerInterface $manager
     */
    public function __construct(Container $container, ApplicationManagerInterface $manager)
    {
        parent::__construct($container);

        $this->manager = $manager;
    }

    /**
     * @return \Application\Core\Entity\ApplicationInterface[]
     */
    protected function getApplications()
    {
        return $this->manager->allInstalled();
    }
}
