<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */
namespace Application\Core\Utilities;

use Application\Core\Entity\AccountInterface;
use Application\Core\Exception\LoginAccountNotFoundException;
use Application\Core\User;

/**
 * Class UserFactory
 */
interface UserFactoryInterface
{
    /**
     * @param null $user_id
     * @return User
     */
    public function getUser($user_id = null);

    /**
     * @param $username_or_email
     * @return AccountInterface
     * @throws LoginAccountNotFoundException
     */
    public function getAccount($username_or_email);
}
