<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Utilities;

use Application\Core\Exception\LoginEmailNotFoundException;
use Application\Core\Exception\LoginUsernameNotFoundException;
use Application\Core\Model\Account;
use Application\Core\User;

/**
 * Class UserFactory
 */
class UserFactory implements UserFactoryInterface
{
    /**
     * {@inheritdoc}
     */
    public function getUser($user_id = null)
    {
        $user = new User();
        $user->setUserId($user_id);

        return $user;
    }

    /**
     * {@inheritdoc}
     */
    public function getAccount($username_or_email)
    {
        if (preg_match(REGEXP_VALIDATE_EMAIL, $username_or_email)) {
            // Ricavo l'account dall'indirizzo e-mail
            $account = Account::findByEmail($username_or_email);

            // Nessun account trovato
            if ($account === null) {
                throw new LoginEmailNotFoundException();
            }
        } else {
            // Ricavo l'account dal nome utente
            $account = Account::findByUsername($username_or_email);

            // Nessun account trovato
            if ($account === null) {
                throw new LoginUsernameNotFoundException();
            }
        }

        return $account;
    }
}
