<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Utilities;

class AssociativeArrayObject extends \ArrayObject
{
    /**
     * @param string|int $search_key
     * @param mixed      $value
     * @param string|int $key
     */
    public function appendAfter($search_key, $value, $key = null)
    {
        $this->insert($search_key, $value, $key, true);
    }

    /**
     * @param string|int $search_key
     * @param mixed      $value
     * @param string|int $key
     */
    public function appendBefore($search_key, $value, $key = null)
    {
        $this->insert($search_key, $value, $key, false);
    }

    /**
     * @param      $value
     * @param null $key
     * @throws \InvalidArgumentException
     */
    public function appendFirst($value, $key = null)
    {
        $ary = $this->getArrayCopy();

        if ($key) {
            if (array_key_exists($key, $ary)) {
                throw new \InvalidArgumentException(sprintf('The key %s already exists.', $key));
            }

            $ary = array_merge(array($key => $value), $ary);
        } else {
            if (is_hash($this->getArrayCopy())) {
                throw new \InvalidArgumentException('The array is a hash, is not possible to handle a mixed (associative/indexed) array with this class');
            }

            array_unshift($ary, $value);
        }

        $this->exchangeArray($ary);
    }

    /**
     * @param      $value
     * @param null $key
     * @throws \InvalidArgumentException
     */
    public function appendLast($value, $key = null)
    {
        $ary = $this->getArrayCopy();

        if ($key) {
            if (array_key_exists($key, $ary)) {
                throw new \InvalidArgumentException(sprintf('The key %s already exists.', $key));
            }

            $ary = array_merge($ary, array($key => $value));
        } else {
            if (is_hash($this->getArrayCopy())) {
                throw new \InvalidArgumentException('The array is a hash, is not possible to handle a mixed (associative/indexed) array with this class');
            }

            array_push($ary, $value);
        }

        $this->exchangeArray($ary);
    }

    /**
     * @param      $search_key
     * @param      $value
     * @param      $key
     * @param bool $after
     * @throws \InvalidArgumentException
     */
    protected function insert($search_key, $value, $key, $after = true)
    {
        if ($key) {
            $ary = $this->getArrayCopy();

            if (array_key_exists($key, $ary)) {
                throw new \InvalidArgumentException(sprintf('The key %s already exists.', $key));
            }

            $offset = $this->arraySearchKey($search_key, $ary) + ($after ? 1 : 0);

            $array_head = array_slice($ary, 0, $offset);
            $array_tail = array_slice($ary, $offset);

            $ary = array_merge($array_head, array($key => $value));
            $ary = array_merge($ary, $array_tail);
        } else {
            if (is_hash($this->getArrayCopy())) {
                throw new \InvalidArgumentException('The array is a hash, is not possible to handle a mixed (associative/indexed) array with this class');
            }

            $ary = array();

            // Devo rinumerare le posizioni successive a quella dell'inserimento, uso un contatore a parte e la chiave
            // reale solo per la ricerca della posizione
            $c = 0;
            foreach ($this->getArrayCopy() as $k => $a) {
                if ($k === $search_key) {
                    if ($after) {
                        $ary[$c++] = $a;
                        $ary[$c] = $value;
                    } else {
                        $ary[$c++] = $value;
                        $ary[$c] = $a;
                    }
                } else {
                    $ary[$c] = $a;
                }

                $c++;
            }
        }

        $this->exchangeArray($ary);
    }

    /**
     * @param mixed $needle
     * @param array $haystack
     *
     * @return int
     */
    protected function arraySearchKey($needle, array $haystack)
    {
        $i = 0;

        foreach ($haystack as $key => $value) {
            if ($key == $needle) {
                return $i;
            }
            $i++;
        }

        return $i;
    }
}
