<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Model\Application;
use Updates\BaseUpdate;

/**
 * Class Update95
 */
class Update95 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        /** @var Application[] $apps */
        $apps = Application::all();
        $positions = array('Core', 'Admin');


        foreach ($apps as $index => $app) {
            $pos = null;

            switch ($app->app_name) {
                case 'Core':
                    $pos = 1;
                    break;
                case 'Admin':
                    $pos = 2;
                    break;
            }

            if ($pos) {
                $app->load_order = $pos;
                $app->save();
                unset($apps[$index]);
            }
        }

        $pos = 10;
        $limit = 0;
        while (!empty($apps) && $limit < 10) {
            $limit++;
            foreach ($apps as $index => $app) {
                /** @var \Pongho\Core\Plugin $kernel_class */
                $kernel_class = 'Application\\' . $app->app_name . '\\Kernel';

                if (!class_exists($kernel_class)) {
                    $app->delete();
                    unset($apps[$index]);
                    continue;
                }

                if (isset($positions[$app->app_name])) {
                    $app->load_order = $positions[$app->app_name];
                    $app->save();
                    unset($apps[$index]);
                    continue;
                }

                $app_deps = $kernel_class::depends();

                if (array_diff($app_deps, $positions) === array()) {
                    $positions[] = $app->app_name;
                    $app->load_order = $pos;
                    $app->save();

                    $pos += 10;

                    unset($apps[$index]);
                }
            }
        }

    }
}
