<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Model\Translation;
use Updates\BaseUpdate;

/**
 * Class Update91
 */
class Update91 extends BaseUpdate
{
    /**
     * Esegue l'aggiornamento
     */
    public function commit()
    {
        Translation::putTranslation('app_warnings', 'Avvertimenti', 'admin', 'it_IT');
        Translation::putTranslation('app_is_installed', 'Installata', 'admin', 'it_IT');
        Translation::putTranslation('app_is_enabled', 'Abilitata', 'admin', 'it_IT');

        Translation::putTranslation('app_could_not_be_disabled', 'L\'applicazione non può essere disattivata : %s', 'admin', 'it_IT');
        Translation::putTranslation('app_could_not_be_enabled', 'L\'applicazione non può essere attivata : %s', 'admin', 'it_IT');
        Translation::putTranslation('app_could_not_be_installed', 'L\'applicazione non può essere installata : %s', 'admin', 'it_IT');
        Translation::putTranslation('app_could_not_be_uninstalled', 'L\'applicazione non può essere disinstallata : %s', 'admin', 'it_IT');

        /*
         * Eccezioni, dovrebbero stare in Core ma vengono visualizzate solo in Admin
         */
        Translation::putTranslation('app_manager_special_exception', 'L\'applicazione è speciale', 'core', 'it_IT');
        Translation::putTranslation('app_manager_dependencies_exception', 'L\'applicazione ha delle dipendenze non soddisfatte [ %s ]', 'core', 'it_IT');
        Translation::putTranslation('app_manager_requirements_exception', 'L\'applicazione è richiesta da altre applicazioni [ %s ]', 'core', 'it_IT');
        Translation::putTranslation('app_manager_kernel_not_exists_exception', 'Il Kernel dell\'applicazione non esiste', 'core', 'it_IT');
        Translation::putTranslation('app_manager_application_not_found_exception', 'L\'applicazione non esiste', 'core', 'it_IT');
    }
}
