<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Updates\BaseUpdate;

/**
 * Update61.
 */
class Update61 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        $platform_name = $this->connection->getDatabasePlatform()->getName();

        switch ($platform_name) {
            case 'mysql':
                $this->connection->exec('ALTER TABLE pongho_addresses CHANGE province province_name VARCHAR(100)');
                break;

            case 'postgresql':
                $this->connection->exec('ALTER TABLE pongho_addresses RENAME COLUMN province TO province_name');
                break;

            default:
                throw new \Exception(sprintf('Database "%s" is not supported.', $this->connection->getDatabasePlatform()->getName()));
        }
    }
}
