<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Model\Country;
use Updates\BaseUpdate;

/**
 * Class Update140
 */
class Update140 extends BaseUpdate
{
    /**
     * Esegue l'aggiornamento
     */
    public function commit()
    {
        /** @var Country[] $countries */
        $countries = array();

        /** @var Country $country */
        foreach (Country::all() as $country) {
            $countries[$country->name] = $country;
        }

        foreach (json_decode(file_get_contents(PONGHO_PATH . '/Application/Core/Installer/Resources/countries.json'), true) as $row) {
            if (array_key_exists($row['name'], $countries)) {
                if (empty($countries[$row['name']]->code)) {
                    $countries[$row['name']]->code = $row['code'];
                }

                if (empty($countries[$row['name']]->code3)) {
                    $countries[$row['name']]->code3 = $row['code3'];
                }

                if (empty($countries[$row['name']]->num)) {
                    $countries[$row['name']]->num = $row['num'];
                }

                if (empty($countries[$row['name']]->postal_name)) {
                    $countries[$row['name']]->postal_name = $row['postal_name'];
                }

                if (empty($countries[$row['name']]->address_template)) {
                    $countries[$row['name']]->address_template = $row['address_template'];
                }

                $countries[$row['name']]->save();
            } else {
                $this->connection->insert(
                    'pongho_countries',
                    $row,
                    array(
                        'name'             => \PDO::PARAM_STR,
                        'code'             => \PDO::PARAM_STR,
                        'code3'            => \PDO::PARAM_STR,
                        'num'              => \PDO::PARAM_STR,
                        'postal_name'      => \PDO::PARAM_STR,
                        'address_template' => \PDO::PARAM_STR,
                    )
                );
            }
        }
    }
}
