<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Tests\Utilities\Link\Utilities;

use Application\Core\Entity\LinkTypeInterface;
use Application\Core\Model\Manager\LinkTypeManagerInterface;
use Application\Core\LinkType\LinkHandlerInterface;

/**
 * Class Mocks
 */
class Mocks
{
    /**
     * @var \PHPUnit_Framework_TestCase
     */
    protected $test;

    /**
     * @param \PHPUnit_Framework_TestCase $test
     */
    public function __construct(\PHPUnit_Framework_TestCase $test)
    {
        $this->test = $test;
    }

    /**
     * @return LinkTypeInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    public function getLinkTypeMock()
    {
        return $this->test->getMock('Application\\Core\\Entity\\LinkTypeInterface');
    }

    /**
     * @return LinkHandlerInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    public function getLinkHandlerMock()
    {
        return $this->test->getMock('Application\\Core\\LinkType\\LinkHandlerInterface');
    }

    /**
     * @return LinkTypeManagerInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    public function getLinkTypeManagerMock()
    {
        return $this->test->getMock('Application\\Core\\Model\\Manager\\LinkTypeManagerInterface');
    }
}
