<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Tests\Utilities\AssociativeArrayObject;


use Application\Core\Utilities\AssociativeArrayObject;

class AssociativeArrayObjectTest extends \PHPUnit_Framework_TestCase
{
    /** @var AssociativeArrayObject */
    protected $obj_assoc;

    /** @var array */
    protected $ary_assoc;

    /** @var AssociativeArrayObject */
    protected $obj_positional;

    /** @var array */
    protected $ary_positional;

    public function setup()
    {
        $this->ary_assoc = array(
            'a' => 'A',
            'b' => 'B',
            'c' => 'C',
        );

        $this->obj_assoc = new AssociativeArrayObject($this->ary_assoc);

        $this->ary_positional = array(
            'A',
            'B',
            'C',
        );

        $this->obj_positional = new AssociativeArrayObject($this->ary_positional);
    }

    public function testArray()
    {
        $this->assertEquals($this->ary_assoc, $this->obj_assoc->getArrayCopy());
        $this->assertEquals($this->ary_positional, $this->obj_positional->getArrayCopy());
    }

    public function testFirstPositional()
    {
        $this->obj_positional->appendFirst('X');

        $this->assertEquals(
            array(
                'X',
                'A',
                'B',
                'C',
            ),
            $this->obj_positional->getArrayCopy()
        );

        $this->obj_positional->appendFirst('Y');

        $this->assertEquals(
            array(
                'Y',
                'X',
                'A',
                'B',
                'C',
            ),
            $this->obj_positional->getArrayCopy()
        );
    }

    /**
     * @expectedException \InvalidArgumentException
     */
    public function testFirstMixed()
    {
        $this->obj_assoc->appendFirst('X');
    }

    public function testFirstWithKey()
    {
        $this->obj_assoc->appendFirst('X', 'x');

        $this->assertEquals(
            array(
                'x' => 'X',
                'a' => 'A',
                'b' => 'B',
                'c' => 'C',
            ),
            $this->obj_assoc->getArrayCopy()
        );
    }

    public function testLastPositional()
    {
        $this->obj_positional->appendLast('X');

        $this->assertEquals(
            array(
                'A',
                'B',
                'C',
                'X',
            ),
            $this->obj_positional->getArrayCopy()
        );

        $this->obj_positional->appendLast('Y');

        $this->assertEquals(
            array(
                'A',
                'B',
                'C',
                'X',
                'Y',
            ),
            $this->obj_positional->getArrayCopy()
        );
    }

    /**
     * @expectedException \InvalidArgumentException
     */
    public function testLastMixed()
    {
        $this->obj_assoc->appendLast('X');
    }

    public function testLastWithKey()
    {
        $this->obj_assoc->appendLast('X', 'x');

        $this->assertEquals(
            array(
                'a' => 'A',
                'b' => 'B',
                'c' => 'C',
                'x' => 'X',
            ),
            $this->obj_assoc->getArrayCopy()
        );
    }

    public function testAfterPositional()
    {
        $this->obj_positional->appendAfter(1, 'X');

        $this->assertEquals(
            array(
                'A',
                'B',
                'X',
                'C',
            ),
            $this->obj_positional->getArrayCopy()
        );

        $this->obj_positional->appendAfter(1, 'Y');

        $this->assertEquals(
            array(
                'A',
                'B',
                'Y',
                'X',
                'C',
            ),
            $this->obj_positional->getArrayCopy()
        );
    }

    /**
     * @expectedException \InvalidArgumentException
     */
    public function testAfterMixed()
    {
        $this->obj_assoc->appendAfter('b', 'X');
    }

    public function testAfterWithKey()
    {
        $this->obj_assoc->appendAfter('b', 'X', 'x');

        $this->assertEquals(
            array(
                'a' => 'A',
                'b' => 'B',
                'x' => 'X',
                'c' => 'C',
            ),
            $this->obj_assoc->getArrayCopy()
        );
    }

    public function testBeforePositional()
    {
        $this->obj_positional->appendBefore(1, 'X');

        $this->assertEquals(
            array(
                'A',
                'X',
                'B',
                'C',
            ),
            $this->obj_positional->getArrayCopy()
        );

        $this->obj_positional->appendBefore(1, 'Y');

        $this->assertEquals(
            array(
                'A',
                'Y',
                'X',
                'B',
                'C',
            ),
            $this->obj_positional->getArrayCopy()
        );
    }

    /**
     * @expectedException \InvalidArgumentException
     */
    public function testBeforeMixed()
    {
        $this->obj_assoc->appendBefore('b', 'X');
    }

    public function testBeforeWithKey()
    {
        $this->obj_assoc->appendBefore('b', 'X', 'x');

        $this->assertEquals(
            array(
                'a' => 'A',
                'x' => 'X',
                'b' => 'B',
                'c' => 'C',
            ),
            $this->obj_assoc->getArrayCopy()
        );
    }

    /**
     * @expectedException \InvalidArgumentException
     */
    public function testAppendAfterKeyExists()
    {
        $this->obj_assoc->appendAfter('a', 'X', 'b');
    }

    /**
     * @expectedException \InvalidArgumentException
     */
    public function testAppendBeforeKeyExists()
    {
        $this->obj_assoc->appendBefore('a', 'X', 'b');
    }

    /**
     * @expectedException \InvalidArgumentException
     */
    public function testAppendFirstKeyExists()
    {
        $this->obj_assoc->appendFirst('X', 'b');
    }

    /**
     * @expectedException \InvalidArgumentException
     */
    public function testAppendLastKeyExists()
    {
        $this->obj_assoc->appendLast('X', 'b');
    }
}
