<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Tests\I18n\Translator;

use Application\Core\I18n\Translator\PhpExtractor;
use Symfony\Component\Translation\MessageCatalogue;

/**
 * Class PhpExtractorTest
 */
class PhpExtractorTest extends \PHPUnit_Framework_TestCase
{
    public function testExtractor()
    {
        $catalogue = new MessageCatalogue('it');
        $extractor = new PhpExtractor();

        $extractor->extract(__DIR__ . '/Fixtures', $catalogue);

        $this->assertTrue($catalogue->has('Tutto in linea'));
        $this->assertTrue($catalogue->has('Metodo a capo'));
        $this->assertTrue($catalogue->has('Stringa a capo'));
        $this->assertTrue($catalogue->has('Stringa splittata in' . "\n" . ' una nuova linea')); // Controllare che il file di esempio sia impostato con separatore di riga a LF
        $this->assertTrue($catalogue->has('Proprietà di classe'));
        $this->assertTrue($catalogue->has('Come servizio'));
        $this->assertTrue($catalogue->has('Da metodo getTranslator()'));
        $this->assertTrue($catalogue->has('Da metodo getTranslator() con stringa a capo'));
        $this->assertTrue($catalogue->has('Da metodo getTranslator() a capo e stringa a capo'));
    }
}
