<?php

namespace Application\Core\Tests\Form\Field;

use Application\Core\Form\Field\PermitsCheckListNamespaceCompiler;

class PermitsCheckListTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @dataProvider compileProvider
     */
    public function testCompile($keys, $expected)
    {
        $compiler = new PermitsCheckListNamespaceCompiler($keys);

        $this->assertEquals($expected, $compiler->compile());
    }

    public function compileProvider()
    {
        return array(
            array(
                array(),
                array(),
            ),
            array(
                array(
                    'foo',
                ),
                array(
                    'foo' => array(
                        'permits' => array(
                            'foo',
                        ),
                    )
                ),
            ),
            array(
                array(
                    'foo',
                    'bar',
                ),
                array(
                    'foo' => array(
                        'permits' => array(
                            'foo',
                        ),
                    ),
                    'bar' => array(
                        'permits' => array(
                            'bar',
                        ),
                    ),
                ),
            ),
            array(
                array(
                    'foo.bar',
                    'foo',
                ),
                array(
                    'foo' => array(
                        'permits' => array(
                            'foo.bar',
                            'foo',
                        ),
                    ),
                ),
            ),
            array(
                array(
                    'foo',
                    'foo.bar',
                    'foo.bar.baz',
                ),
                array(
                    'foo' => array(
                        'permits' => array(
                            'foo',
                        ),
                        'fieldset' => array(
                            'foo.bar' => array(
                                'permits' => array(
                                    'foo.bar',
                                    'foo.bar.baz',
                                ),
                            ),
                        ),
                    )
                ),
            ),
            array(
                array(
                    'admin',
                    'blog.admin',
                    'blog.add',
                    'blog.edit',
                    'blog.delete',
                    'blog.category.admin',
                    'blog.category.add',
                    'blog.category.edit',
                    'blog.category.delete',
                    'blog.tag.admin',
                    'blog.tag.add',
                    'blog.tag.edit',
                    'blog.tag.delete',
                ),
                array(
                    'admin' => array(
                        'permits' => array('admin'),
                    ),
                    'blog' => array(
                        'permits' => array(
                            'blog.admin',
                            'blog.add',
                            'blog.edit',
                            'blog.delete',
                        ),
                        'fieldset' => array(
                            'blog.category' => array(
                                'permits' => array(
                                    'blog.category.admin',
                                    'blog.category.add',
                                    'blog.category.edit',
                                    'blog.category.delete',
                                ),
                            ),
                            'blog.tag' => array(
                                'permits' => array(
                                    'blog.tag.admin',
                                    'blog.tag.add',
                                    'blog.tag.edit',
                                    'blog.tag.delete',
                                ),
                            ),
                        ),
                    ),
                )
            ),
            array(
                array(
                    'baz',
                    'foo',
                    'foo.bar',
                    'foo.baz',
                    'bar',
                    'bar.foo',
                    'bar.bar',
                    'bar.bar.foo',
                ),
                array(
                    'baz' => array(
                        'permits' => array(
                            'baz',
                        ),
                    ),
                    'foo' => array(
                        'permits' => array(
                            'foo',
                            'foo.bar',
                            'foo.baz',
                        ),
                    ),
                    'bar' => array(
                        'permits' => array(
                            'bar',
                            'bar.foo',
                        ),
                        'fieldset' => array(
                            'bar.bar' => array(
                                'permits' => array(
                                    'bar.bar',
                                    'bar.bar.foo',
                                ),
                            ),
                        )
                    ),
                ),
            ),
        );
    }
}
