<?php

namespace Application\Core\Routes;

use Application\Core\Model\Account;
use Pongho\Http\Exception\HttpNotFoundException;
use Pongho\Http\RedirectResponse;
use Pongho\Http\Request;
use Pongho\Routing\RouteInterface;

class UserViewRoute implements RouteInterface
{
	/**
	 * @var \Application\Core\Model\Account
	 */
    protected $account;

    /**
     * @var string
     */
    protected $path;

    /**
     * @var string
     */
    protected $action = 'view';

    /**
     * @var array
     */
    protected $options = array(
        '_controller' => 'Application\\Core\\Controller\\UserController',
    );

    /**
     * @param string $path
     * @param array $options
     */
    public function __construct($path = '/user/view', array $options = array())
    {
        $this->path = '/' . trim($path, '/');

        $this->options = array_merge($this->options, $options);
    }

    /**
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

	/**
	 * @implements RouteInterface
	 */
	public function match(Request $request)
	{
        if (strpos($request->getPathInfo(), $this->path) === 0) {
            $path = substr($request->getPathInfo(), strlen($this->path));

            $segments = explode('/', trim($path, '/'));

            if (($url = array_shift($segments)) === null) {
                return false;
            }

            if (isset($segments[0])) {
                $this->action = $segments[0];
            }

            $account = Account::first(
                array(
                    'conditions' => array('old_url = ?', $url),
                )
            );

            if ($account) {
                return new RedirectResponse($this->path . '/' . $account->url . '/');
            }

            $account = Account::first(
                array(
                    'conditions' => array('url = ?', $url),
                )
            );

            if ($account === null) {
                return false;
            }

            $this->account = $account;

            return true;
        }

		return false;
	}

	/**
	 * @implements RouteInterface
	 */
	public function getController()
	{
		return $this->options['_controller'];
	}

	/**
	 * @implements RouteInterface
	 */
	public function getAction()
	{
        return $this->action;
	}

	/**
	 * @implements RouteInterface
	 */
	public function getParameters()
	{
		return array(
			'account' => $this->account,
		);
	}
}
