<?php

namespace Application\Core\Routes;

use Pongho\Core\Kernel;
use Pongho\Http\Request;
use Pongho\Routing\RouteInterface;

class ModulesRoute implements RouteInterface
{
	protected $module;

	protected $language;

	protected $action = 'index';

	protected $id;

	public function match(Request $request)
	{
		$site = Kernel::instance()->getContainer()->getService('site');

		foreach ( $site->getLanguagesModules() as $language_module )
		{
			if ( $request->getPathInfo() == $language_module->path )
			{
				$this->module = $language_module->getSiteModule();
				$this->language = $language_module->getSiteLanguage();
				$this->action = 'index';

				break;
			}
		}

		if ( $this->module !== null )
		{
			return true;
		}

		foreach ( $site->getLanguagesModules() as $language_module )
		{
			if ( strpos($request->getPathInfo(), $language_module->path) === 0 )
			{
				$this->module = $language_module->getSiteModule();
				$this->language = $language_module->getSiteLanguage();

				$segments = explode('/', substr($request->getPathInfo(), strlen($language_module->path)));

				if ( isset($segments[0]) )
				{
					$this->action = $segments[0];

					if ( isset($segments[1]) )
					{
						$this->id = $segments[1];
					}
				}

				break;
			}
		}

		if ( $this->module === null )
		{
			return false;
		}

		return true;
	}

	public function getController()
	{
		return $this->module->controller;
	}

	public function getAction()
	{
		return $this->action;
	}

	public function getParameters()
	{
		return array(
			'site_module' => $this->module,
			'site_language' => $this->language,
			'id' => $this->id,
		);
	}
}
