<?php

namespace Application\Core\Routes;

use Pongho\Http\Request;
use Pongho\Routing\RouteInterface;

class ImagesRoute implements RouteInterface
{
	private $image_path;

	public function match(Request $request)
	{
		if ( strpos($request->getPathInfo(), '/content/images') === 0 )
		{
			$this->image_path = substr($request->getPathInfo(), 15); // rimuovo il pezzo '/content/images', 15 caratteri

			return true;
		}

        return false;
	}

	public function getController()
	{
		return 'Application\\Core\\Controller\\ImagesController';
	}

	public function getAction()
	{
		return 'display';
	}

	public function getParameters()
	{
		return array(
			'image_path' => $this->image_path,
		);
	}
}
