<?php

namespace Application\Core\Routes;

use Pongho\Http\Request;
use Pongho\Routing\RouteInterface;

class ApiRoute implements RouteInterface
{
    protected $controller;
    protected $action = 'index';
    protected $command;
    protected $format = 'html';
    protected $valid_formats = array('html', 'json', 'xml');

    public function match(Request $request)
    {
        $path_info = $request->getPathInfo();

        if (($pos = strrpos($path_info, '.')) !== false) {
            $format = substr($path_info, $pos + 1);

            if (in_array($format, $this->valid_formats)) {
                $this->format = $format;

                $path_info = substr($path_info, 0, $pos);
            }
        }

        if (strpos($path_info, '/api/') === 0) {
            $path = substr($path_info, 5); // rimuovo il pezzo '/api/', 5 caratteri

            $segments = explode('/', trim($path, '/'));

            if (($app = array_shift($segments)) === null) {
                return false;
            }

            if ($app === 'custom') {
                if (($app = array_shift($segments)) === null) {
                    return false;
                }

                $this->controller = 'Plugins\\' . ucfirst($app) . '\\ApiController';
            } else {
                $this->controller = 'Application\\' . ucfirst($app) . '\\Controller\\ApiController';
            }

            if (($action = array_shift($segments)) !== null) {
                $this->action = $action;
            }

            $this->command = trim(implode('/', $segments), '/');

            return true;
        }

        return false;
    }

    public function getController()
    {
        return $this->controller;
    }

    public function getAction()
    {
        return $this->action;
    }

    public function getParameters()
    {
        return array(
            'command' => $this->command,
            'format'  => $this->format,
        );
    }
}
