<?php
/**
 * @var \Application\Core\Localization $lang
 * @var array                          $headers
 * @var array                          $rows
 * @var string                         $action_form
 */
?><form action="<?php echo $action_form; ?>" method="post" class="section" enctype="multipart/form-data" style="overflow: auto;">

	<h2><?php echo $lang->get('users_import_title'); ?></h2>
	<p><?php echo $lang->get('users_import_explain'); ?></p>

	<?php
    include 'tabs.php';
	include 'messages.php';
    ?>

	<?php if (!$rows): ?>
	<fieldset class="panel">
		<dl class="extend">
			<dt><label for="field-file-import"><?php echo $lang->get('file_import'); ?></label></dt>
			<dd class="smaller">
				<input type="file" name="file_import" id="field-file-import" />
				<div><?php echo $lang->get('file_import_explain'); ?></div>
			</dd>
		</dl>
	</fieldset>

	<fieldset class="btn top">
		<input type="submit" value="<?php echo $lang->get('load'); ?>" class="primary" />
	</fieldset>
	<?php else: ?>
	<fieldset class="btn top">
		<input type="submit" value="<?php echo $lang->get('import'); ?>" class="primary" />
	</fieldset>

	<fieldset class="panel">
		<table class="pongho-table">
			<thead>
				<tr>
				<?php foreach($headers as $col_num => $header): $col_head = array_shift($header); ?>
					<th>
						<select style="display: block; width: 150px;" name="columns[<?php echo $col_num; ?>]"><?php echo $header['select']; ?></select>
						<input type="hidden" name="headers[<?php echo $col_num; ?>]" value="<?php echo $col_head; ?>" />
						<?php echo $col_head; ?>
					</th>
				<?php endforeach; ?>
				</tr>
			</thead>

			<tbody>
			<?php foreach($rows as $i => $row): ?>
				<?php if (!isset($row['error'])): ?>
					<tr>
					<?php foreach($headers as $col_num => $col_head): ?>
						<td>
							<?php echo $value = array_key_exists($col_num, $row) ? html_escape($row[$col_num]) : '';	?>
							<input type="hidden" name="rows[<?php echo $i; ?>][<?php echo $col_num; ?>]" value="<?php echo $value; ?>" />
						</td>
					<?php endforeach; ?>
					</tr>
				<?php else: ?>
                    <tr><th style="background: transparent;" colspan="<?php echo count($headers); ?>"><?php echo $row['error']; ?></th></tr>
					<tr>
					<?php foreach($headers as $col_num => $col_head): ?>
						<?php $value = array_key_exists($col_num, $row) ? html_escape($row[$col_num]) : ''; ?>
						<td>
						<?php if ( isset($col_head['type']) && $col_head['type'] === 'group' ): ?>
							<input type="checkbox" name="rows[<?php echo $i; ?>][<?php echo $col_num; ?>]"<?php echo $value ? ' checked="checked"' : ''; ?> />
						<?php else:	?>
							<input type="text" class="input_text" name="rows[<?php echo $i; ?>][<?php echo $col_num; ?>]" value="<?php echo $value; ?>" />
						<?php endif; ?>
						</td>
					<?php endforeach; ?>
					</tr>
                <?php endif; ?>
			<?php endforeach; ?>
			</tbody>
		</table>
	</fieldset>
	<?php endif; ?>

</form><!-- .section -->
