<form action="<?php echo $action_form ?>" method="post" class="section checksave">

	<h2><?php echo $lang->languages_title ?></h2>

	<?php include 'messages.php' ?>

	<?php include 'tabs.php' ?>

	<fieldset class="panel">
		<p><?php printf($lang->enabled_languages_explain, $site->name); ?></p>

		<table class="pongho-table">
			<thead>
				<tr>
					<th class="main"><?php echo $lang->language; ?></th>
					<th><?php echo $lang->path; ?></th>
					<th><?php echo $lang->enabled; ?></th>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<th class="main"><?php echo $lang->language; ?></th>
					<th><?php echo $lang->path; ?></th>
					<th><?php echo $lang->enabled; ?></th>
				</tr>
			</tfoot>

			<tbody>
				<?php foreach ( $rows as $row ): ?>
					<tr>
						<td class="main">
							<?php printf('<img class="flag" src="%s" alt="%s" title="%s" />', pongho_url("/Application/Core/Resources/flags/16/{$row->culture}.png"), $row->iso, $row->name); ?>
							<input type="hidden" name="languages[<?php echo $row->language_id ?>][language_id]" value="<?php echo $row->language_id; ?>" />
							<?php echo $row->name; ?>
						</td>
						<td><?php echo $row->path ?></td>
						<td><input type="checkbox" name="languages[<?php echo $row->language_id ?>][is_enabled]" <?php echo $row->is_enabled ? ' checked="checked"' : ''?> ></td>
					</tr>
				<?php endforeach; ?>

				<tr class="clonable">
					<td class="main"><select name="languages[new][language_id]"><option value=""></option><?php echo $html->select($languages); ?></select></td>
					<td><input type="text" name="languages[new][path]" value="" class="input_text" style="width: 150px;"></td>
					<td><input type="checkbox" name="languages[new][is_enabled]"></td>
				</tr>
			</tbody>
		</table>
	</fieldset><!-- .panel -->

	<fieldset class="btn">
		<input type="submit" value="<?php echo $lang->save ?>" class="primary" />
	</fieldset>

</div><!-- .section -->
