/*jslint nomen: true, plusplus: true, passfail: true, browser: true, devel: true */
/*global $, jQuery */
//(function ($) {
//    "use strict";
//
//    $.fn.serializeFiles = function () {
//        var obj = $(this),
//            formData = new FormData();
//
//        /* ADD FILE TO PARAM AJAX */
//        $.each(obj.find("input[type='file']"), function (i, tag) {
//            $.each($(tag)[0].files, function (i, file) {
//                formData.append(tag.name, file);
//            });
//        });
//
//        $.each(obj.serializeArray(), function (i, val) {
//            formData.append(val.name, val.value);
//        });
//
//        return formData;
//    };
//}(jQuery));

// http://jquery.malsup.com/form/ provare a vedere se questo plugin può essere d'aiuto per semplificare le operazioni

$(document).ready(function () {
    "use strict";

    var manageNotifications = function () {
            var panel = $('#fieldset-user-notifications'),
                status = $('#field-user-is_active'),
                notifyEdit = panel.find('#field-user-notify_edit').prop('checked', false),
                notifyStatus = panel.find('#field-user-notify_status').prop('checked', false),
                notifyCredentials = panel.find('#field-user-notify_credentials').prop('checked', false),
                notifyCreation = panel.find('#field-user-notify_create').prop('checked', false),
                notifyLink = panel.find('#field-user-notify_activation_link').prop('checked', false),
                initialStatus = status.val();

            // Le notifiche inviabili variano in base allo stato che viene impostato, disattivando un account non ha senso notificare
            // nuove credenziali o la modifica dell'account
            function presetCheckboxes() {
                if (Pongho.action === 'add') {
                    notifyCreation.attr('disabled', false).prop('checked', true);
                } else {
                    if (status.val() === 'active') {
                        // Rimuovo il campo dal DOM se sono passato da "add" a "edit"
                        notifyLink.closest('.control-group').remove();

                        // Attivo le notifiche e suggerisco di inviare la notifica per il cambiamento dello stato
                        notifyEdit.attr('disabled', false);
                        notifyStatus.attr('disabled', true);
                        notifyCredentials.attr('disabled', false);
                    } else if (status.val() === 'pending') {
                        // Disattivo le notifiche non inviabili, attivo la notifica per la creazione (ce l'ho se sono in "add")
                        notifyLink.attr('disabled', false);
                        notifyEdit.attr('disabled', true);
                        notifyStatus.attr('disabled', true);
                        notifyCredentials.attr('disabled', true);
                    } else {
                        // Rimuovo il campo dal DOM se sono passato da "add" a "edit"
                        notifyLink.remove();

                        // Disattivo le notifiche non inviabili, attivo e suggerisco la notifica per il cambiamento dello stato
                        notifyEdit.attr('disabled', true);
                        notifyStatus.attr('disabled', true);
                        notifyCredentials.attr('disabled', true);
                    }
                }
            }

            presetCheckboxes();
            status.on(
                'change',
                function () {
                    if (Pongho.action === 'add') {
                        if (status.val() === 'active' || status.val() === 'pending') {
                            notifyCreation.attr('disabled', false).prop('checked', true);
                        } else {
                            notifyCreation.attr('disabled', true).prop('checked', false);
                        }
                    } else {
                        if (status.val() === 'active') {
                            // Attivo le notifiche e suggerisco di inviare la notifica per il cambiamento dello stato
                            notifyLink.attr('disabled', true);
                            notifyEdit.attr('disabled', false);
                            notifyStatus.attr('disabled', initialStatus === status.val()).prop('checked', initialStatus !== status.val());
                            notifyCredentials.attr('disabled', false);
                        } else if (status.val() === 'pending') {
                            // Disattivo le notifiche non inviabili, attivo la notifica per la creazione (ce l'ho se sono in "add")
                            notifyLink.attr('disabled', false).prop('checked', false);
                            notifyEdit.attr('disabled', true).prop('checked', false);
                            notifyStatus.attr('disabled', true).prop('checked', false);
                            notifyCredentials.attr('disabled', true).prop('checked', false);
                        } else {
                            // Disattivo le notifiche non inviabili, attivo e suggerisco la notifica per il cambiamento dello stato
                            notifyLink.attr('disabled', true).prop('checked', false);
                            notifyEdit.attr('disabled', true).prop('checked', false);
                            notifyStatus.attr('disabled', initialStatus === status.val()).prop('checked', initialStatus !== status.val());
                            notifyCredentials.attr('disabled', true).prop('checked', false);
                        }
                    }
                }
            );
        },
        onCreatePanel = function () {
            $('#field-user-password').managePassword();
            manageNotifications();
        },
        tabsPanel = $('.form-wrapper');

    if (Pongho.action !== 'add') {
        tabsPanel.on('after-update', function () {
            onCreatePanel($(this));
        });
    }

    onCreatePanel(tabsPanel);

//    $('.tabsPanel').each(function () {
//        $('a.preview').colorbox();
//
//        var panel = $(this), button, action = '';
//
//        panel.on('click', 'button[type="submit"]', function (event) {
//            button = this;
//            action = button.value;
//        });
//
//        panel.on('submit', 'form', function (event) {
//            event.preventDefault();
//
//            var form = $(this),
//                formData,
//                processData = false,
//                contentType = false;
//
//            // IE <= 9
//            if (window.FormData === undefined) {
//                formData = form.serializeArray();
//                processData = true;
//                contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
//
//                if (action !== '') {
//                    formData.push({
//                        'name': button.name,
//                        'value': action
//                    });
//                }
//            } else {
//                formData = form.serializeFiles();
//
//                if (button !== '') {
//                    formData.append(button.name, action);
//                }
//            }
//
//            $.ajax({
//                url: form.attr('action'),
//                data: formData,
//                type: 'POST',
//                processData: processData,
//                contentType: contentType,
//                dataType: 'html',
//                success: function (response) {
//                    panel.html(response);
//
//                    $('#box-info', panel).hide().fadeIn();
//                    $('a.preview', panel).colorbox(); // Ricollego il colorbox per i pannelli ricaricati in AJAX
//
//                    $('body').trigger('pongho_panel_recreate');
//                }
//            });
//        });
//    });

    $('#field-user-url-btn').on('click', function () {
        var openBtn = $(this), url;

        openBtn.colorbox({
            'href'   : openBtn.data('form'),
            'width'  : 500,
            'height' : 400,
            'onComplete' : function () {
                var form = $('#account-url-form'),
                    input = $('#account-url'),
                    confirm = $('#account-url-confirm');

                form.on('click', 'button', function () {
                    var button = this,
                        data = form.serializeArray();

                    input.on('change', function () {
                        confirm.hide();
                    });

                    data.push({
                        'name': 'action',
                        'value': button.name
                    });

                    $.ajax({
                        'url': form.attr('action'),
                        'data': data,
                        'type': 'POST',
                        'success': function (response) {
                            var infoBox = $('#account-url-errors').empty();

                            if (response.error) {
                                infoBox.html('<div class="box error">' + response.message + '</div>');
                                return;
                            }

                            infoBox.html('<div class="box info">' + response.message + '</div>');

                            if (response.url) {
                                input.val(response.url);
                                confirm.show();
                            }

                            if (button.name === 'confirm') {
                                url = input.val();

                                $.colorbox.close();
                            }
                        }
                    });
                });

                form.on('submit', function (event) {
                    event.preventDefault();
                });
            },
            'onClosed': function () {
                if (url) {
                    $('#field-user-url').html(url);
                    openBtn.remove();
                }
            }
        });
    });
});
