<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

use Application\Core\Entity\LanguageInterface;

/**
 * Class UserSubscribeNotification
 */
abstract class UserSubscribeNotification extends AbstractNotification
{
    use HasAccountTrait, HasPasswordTrait, HasSettingsLinkTrait;

    /**
     * {@inheritdoc}
     */
    public function getOptions()
    {
        if ($this->options === null) {
            $this->options = new NotificationOptions(true, true, false, true, true, false);
        }

        return $this->options;
    }

    /**
     * @return LanguageInterface
     */
    public function getLanguage()
    {
        return $this->account->getLanguage();
    }

    /**
     * {@inheritdoc}
     */
    public function getVars()
    {
        $vars = parent::getVars();

        $vars[] = 'USER_USERNAME';
        $vars[] = 'USER_EMAIL';
        $vars[] = 'USER_FULL_NAME';
        $vars[] = 'USER_PASSWORD';
        $vars[] = 'USER_SETTINGS_LINK';

        return $vars;
    }

    /**
     * {@inheritdoc}
     */
    public function getEmailVars()
    {
        $vars = parent::getEmailVars();

        $vars['USER_USERNAME'] = $this->getAccount()->getUsername();
        $vars['USER_EMAIL'] = $this->getAccount()->getEmail();
        $vars['USER_FULL_NAME'] = $this->getAccount()->name(); // todo: anagrafica
        $vars['USER_PASSWORD'] = $this->getPassword();
        $vars['USER_SETTINGS_LINK'] = $this->getSettingsLink();

        return $vars;
    }
}
