<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

/**
 * Class UserCreationActivationNotification
 */
class UserCreationActivationNotification extends AbstractNotification
{
    use HasAccountTrait, HasPasswordTrait, HasAccountActivationLinkTrait;

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'core.user_create_pending';
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle()
    {
        return $this->translator->trans('New user creation by admin with activation link');
    }

    /**
     * {@inheritdoc}
     */
    public function getOptions()
    {
        if ($this->options === null) {
            $this->options = new NotificationOptions(false, true, false, true, true, false);
        }

        return $this->options;
    }

    /**
     * {@inheritdoc}
     */
    public function getLanguage()
    {
        return $this->getAccount()->getLanguage();
    }

    /**
     * {@inheritdoc}
     */
    public function getVars()
    {
        $vars = parent::getVars();

        $vars[] = 'USER_USERNAME';
        $vars[] = 'USER_EMAIL';
        $vars[] = 'USER_FULL_NAME';
        $vars[] = 'USER_PASSWORD';
        $vars[] = 'USER_ACTIVATION_LINK';

        return $vars;
    }

    /**
     * {@inheritdoc}
     */
    public function getEmailVars()
    {
        $vars = parent::getEmailVars();

        $vars['USER_USERNAME'] = $this->getAccount()->getUsername();
        $vars['USER_EMAIL'] = $this->getAccount()->getEmail();
        $vars['USER_FULL_NAME'] = $this->getAccount()->name(); // todo: anagrafica
        $vars['USER_PASSWORD'] = $this->getPassword();
        $vars['USER_ACTIVATION_LINK'] = $this->getAccountActivationLink();

        return $vars;
    }
}
