<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

/**
 * Class SendActivationLinkNotification
 */
class SendActivationLinkNotification extends AbstractNotification
{
    use HasAccountTrait, HasAccountActivationLinkTrait;

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'core.user_send_activation_link';
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle()
    {
        return $this->translator->trans('Send new activation link to user');
    }

    /**
     * {@inheritdoc}
     */
    public function getOptions()
    {
        if ($this->options === null) {
            $this->options = new NotificationOptions(false, true, false, true, true, false);
        }

        return $this->options;
    }

    /**
     * {@inheritdoc}
     */
    public function getLanguage()
    {
        return $this->getAccount()->getLanguage();
    }

    /**
     * {@inheritdoc}
     */
    public function getVars()
    {
        $vars = parent::getVars();

        $vars[] = 'USER_USERNAME';
        $vars[] = 'USER_EMAIL';
        $vars[] = 'USER_FULL_NAME';
        $vars[] = 'USER_ACTIVATION_LINK';

        return $vars;
    }

    /**
     * {@inheritdoc}
     */
    public function getEmailVars()
    {
        $vars = parent::getEmailVars();

        $vars['USER_USERNAME'] = $this->getAccount()->getUsername();
        $vars['USER_EMAIL'] = $this->getAccount()->getEmail();
        $vars['USER_FULL_NAME'] = $this->getAccount()->name(); // todo: anagrafica
        $vars['USER_ACTIVATION_LINK'] = $this->getAccountActivationLink();

        return $vars;
    }
}
