<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

/**
 * Class HasResetPasswordLinkTrait
 */
trait HasResetPasswordLinkTrait
{
    /**
     * @var string
     */
    protected $reset_password_link;

    /**
     * @return string
     */
    public function getResetPasswordLink()
    {
        if ($this->reset_password_link === null) {
            throw new \BadMethodCallException('You first need to set the reset password link!');
        }

        return $this->reset_password_link;
    }

    /**
     * @param string $reset_link
     */
    public function setResetPasswordLink($reset_link)
    {
        $this->reset_password_link = $reset_link;
    }
}
