<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

/**
 * Class HasAccountActivationLinkTrait
 */
trait HasAccountActivationLinkTrait
{
    /**
     * @var string
     */
    protected $account_activation_link;

    /**
     * @return string
     */
    public function getAccountActivationLink()
    {
        if ($this->account_activation_link === null) {
            throw new \BadMethodCallException('You first need to set the account activation link!');
        }

        return $this->account_activation_link;
    }

    /**
     * @param string $activation_link
     */
    public function setAccountActivationLink($activation_link)
    {
        $this->account_activation_link = $activation_link;
    }
}
