<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

use ActiveRecord\Base;
use Application\Core\Entity\RegionInterface;

/**
 * Modello per le regioni.
 *
 * @property int    $id
 * @property string $name
 * @property string $name_long
 * @property string $url
 */
class Region extends Base implements RegionInterface
{
    /**
     * Nome della tabella.
     *
     * @static
     * @var string
     */
    public static $table_name = 'regions';

    /**
     * __toString
     *
     * @return string
     */
    public function __toString()
    {
        return $this->name;
    }
}
