<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\SiteInterface;

/**
 * Interface SiteManagerInterface
 */
interface SiteManagerInterface
{
    /**
     * @param int $site_id
     * @return SiteInterface
     */
    public function findById($site_id);

    /**
     * @return SiteInterface[]
     */
    public function findAll();

    /**
     * @return SiteInterface
     */
    public function getMainSite();

    /**
     * @param SiteInterface $site
     * @return SiteInterface
     */
    public function save(SiteInterface $site);
}
