<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\SiteInterface;
use Application\Core\Model\Site;

/**
 * Class SiteManager
 */
class SiteManager extends AbstractCoreManager implements SiteManagerInterface
{
    /**
     * @var bool
     */
    protected $prepared = false;

    /**
     * @var string
     */
    static $model = 'Site';

    /**
     * {@inheritdoc}
     */
    public function findById($site_id)
    {
        $this->prepare();

        $model = $this->getCache()->get(static::$model, $site_id);

        if (!$model) {
            throw new \InvalidArgumentException(sprintf('The site "%s" is undefined', $site_id));
        }

        return $model;
    }

    /**
     * {@inheritdoc}
     */
    public function findAll()
    {
        $this->prepare();

        return $this->getCache()->all(static::$model);
    }

    /**
     * {@inheritdoc}
     */
    public function getMainSite()
    {
        return $this->findById(1);
    }

    /**
     * @param SiteInterface|Site $site
     * {@inheritdoc}
     */
    public function save(SiteInterface $site)
    {
        if (!$site->save()) {
            throw new \Exception();
        }

        $this->getCache()->clear();

        return $this;
    }

    /**
     * Precarica i modelli per la cache interna
     */
    protected function prepare()
    {
        if ($this->prepared) {
            return;
        }

        /** @var Site $model */
        foreach (Site::all() as $model) {
            $this->getCache()->set(static::$model, $model->getId(), $model);
        }

        $this->prepared = true;
    }
}
