<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\LanguageInterface;

/**
 * Interface LanguageManagerInterface
 */
interface LanguageManagerInterface
{
    /**
     * @param int $language_id
     * @return LanguageInterface
     */
    public function findById($language_id);

    /**
     * @return LanguageInterface[]
     */
    public function findAll();

    /**
     * @param int $module_id
     * @param int $site_id
     * @return LanguageInterface[]
     */
    public function findAllByModuleAndSite($module_id, $site_id);

    /**
     * @param int $module_site_id
     * @return LanguageInterface[]
     */
    public function findAllByModuleSite($module_site_id);

    /**
     * @param $site_id
     * @return LanguageInterface[]
     */
    public function findAllBySite($site_id);

    /**
     * @param LanguageInterface $language
     * @return $this
     */
    public function save(LanguageInterface $language);
}
