<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Model\Manager;

interface ApplicationManagerInterface
{
    /**
     * @return \Application\Core\Entity\ApplicationInterface[]
     */
    public function allEnabled();

    /**
     * @return \Application\Core\Entity\ApplicationInterface[]
     */
    public function allInstalled();

    /**
     * @param string $app_name
     * @return bool
     */
    public function isInstalled($app_name);

    /**
     * @param string $app_name
     * @return bool
     */
    public function isEnabled($app_name);

    /**
     * @param string $app_name
     */
    public function createApplication($app_name);

    /**
     * @param $app_name
     */
    public function deleteApplication($app_name);

    /**
     * @param string $app_name
     */
    public function createApplicationSite($app_name);

    /**
     * @param $app_name
     */
    public function deleteApplicationSite($app_name);

    /**
     * @param string $app_name
     * @return \Application\Core\Entity\ApplicationInterface|null
     */
    public function findByAppName($app_name);
}
