<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

use ActiveRecord\Base;
use Application\Core\Entity\CountryInterface;

/**
 * Modello per i paesi.
 *
 * @property int    $id
 * @property string $name
 * @property string $postal_name
 * @property string $code
 * @property string $code3
 * @property string $address_template
 */
class Country extends Base implements CountryInterface
{
    /**
     * Nome della tabella.
     *
     * @static
     * @var string
     */
    public static $table_name = 'countries';

    /**
     * __toString
     *
     * @return string
     */
    public function __toString()
    {
        return $this->name;
    }
}
