<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

use ActiveRecord\Base;
use Application\Core\Entity\CityInterface;

/**
 * City.
 *
 * @property int    $id
 * @property int    $province_id
 * @property int    $region_id
 * @property string $name
 */
class City extends Base implements CityInterface
{
    /**
     * Nome della tabella.
     *
     * @static
     * @var string
     */
    public static $table_name = 'cities';

    /**
     * @static
     * @param $region_id
     * @return \Application\Core\Model\City[]
     */
    public static function allByRegion($region_id)
    {
        $options = array(
            'conditions' => array('region_id = :region', 'region' => $region_id),
            'order'      => 'name',
        );

        return static::all($options);
    }

    /**
     * @static
     * @param $province_id
     * @return \Application\Core\Model\City[]
     */
    public static function allByProvince($province_id)
    {
        $options = array(
            'conditions' => array('province_id = :province', 'province' => $province_id),
            'order'      => 'name',
        );

        return static::all($options);
    }

    /**
     * __toString
     *
     * @return string
     */
    public function __toString()
    {
        return $this->name;
    }
}
