<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Model;

use ActiveRecord\Base;

/**
 * Class ApplicationSite
 *
 * @property integer                             $app_id
 * @property integer                             $site_id
 * @property \Application\Core\Model\Application $application
 * @property \Application\Core\Model\Site        $site
 */
class ApplicationSite extends Base
{
    public static $table_name = 'apps_sites';

    public static $primary_key = array('app_id', 'site_id');

    public static $belongs_to = array(
        array('application', 'model' => 'Application\\Core\\Model\\Application'),
        array('site', 'model' => 'Application\\Core\\Model\\Site'),
    );
}
