<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\LinkType;

use Application\Core\Entity\LinkTypeDetails;
use Application\Core\Entity\LinkTypeInterface;

interface LinkHandlerInterface
{
    /**
     * @return string
     */
    public function getName();

    /**
     * @return string
     */
    public function getLabel();

    /**
     * @param array $request
     * @return string
     */
    public function getUrl(array $request);

    /**
     * @param LinkTypeInterface $link_type
     * @return int|string
     */
    public function getValue(LinkTypeInterface $link_type);

    /**
     * @param array $request
     * @return LinkTypeDetails
     */
    public function getDetails(array $request);

    /**
     * @return string|null
     */
    public function getGroup();

    /**
     * @param string $name
     * @param mixed  $value
     * @return string
     */
    public function render($name, $value = null);
}
