<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package @todo
 */

namespace Application\Core\LinkType;

use Application\Core\Model\Manager\LinkTypeManagerInterface;
use Pongho\Template\Html;

class LinkFacadeFactory
{
    /**
     * @var LinkHandlerCollection
     */
    protected $collections_factory = array();

    /**
     * @var LinkHandlerCollectionFactory
     */
    protected $manager;

    /**
     * @var Html
     */
    protected $html;
    /**
     * @param LinkHandlerCollectionFactory    $collections_factory
     * @param LinkTypeManagerInterface $manager
     * @param Html                     $html
     */
    public function __construct(LinkHandlerCollectionFactory $collections_factory, LinkTypeManagerInterface $manager, Html $html)
    {
        $this->collections_factory = $collections_factory;
        $this->manager = $manager;
        $this->html = $html;
    }

    /**
     * @param $name
     * @param $language_id
     * @return LinkFacade
     */
    public function create($name, $language_id)
    {
        return new LinkFacade($this->collections_factory->create($name, $language_id), $this->manager, $this->html);
    }
}
