<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core;

require __DIR__ . '/functions.php';

use Application\Admin\Widget\Stats\Collection;
use Application\Core\Model\Account;
use Application\Core\Model\Role;
use Application\Core\Dashboard\Widget\UserStats;
use Pongho\Core\Plugin;
use Pongho\EventDispatcher\Event;

/**
 * Kernel dell’applicazione.
 */
class Kernel extends Plugin
{
    /**
     * Indica la versione dell’applicazione.
     */
    const VERSION = '1.0.0-dev';

    /**
     * {@inheritdoc}
     */
    public function setUp()
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function load()
    {
        // Info: I servizi del Core sono registrati in AppKernel::registerComponents()

        $this->connect('admin.dashboard.widgets.filter_stats', 'addUserStats');
    }

    /**
     * {@inheritdoc}
     */
    public function install()
    {
    }

    /**
     * {@inheritdoc}
     */
    public function uninstall()
    {
    }

    /**
     * {@inheritdoc}
     */
    public function enable()
    {
    }

    /**
     * {@inheritdoc}
     */
    public function disable()
    {
    }

    /**
     * @param \Pongho\EventDispatcher\Event              $event
     * @param \Application\Admin\Widget\Stats\Collection $stats
     *
     * @return \Application\Admin\Widget\Stats\Collection
     */
    public function addUserStats(Event $event, Collection $stats)
    {
        $options = array(
            'select'     => '`from`.*, COUNT(a.id) AS accounts',
            'joins'      => 'INNER JOIN ' . Account::tableName() . ' AS a ON a.role_id = `from`.id',
            'conditions' => array('`from`.id <> :role', 'role' => Role::USER_NOT_LOGGED),
            'group'      => '`from`.id',
        );

        $stats->add(new UserStats($this->container, Role::all($options)));

        return $stats;
    }
}
