<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\I18n\Translator;

use Pongho\Core\LocalizationInterface;
use Pongho\Utilities\Inflector;

class Translator extends \Symfony\Component\Translation\Translator implements LocalizationInterface
{
    /**
     * {@inheritdoc}
     */
    public function get($key, $count = null)
    {
        if (is_int($count)) {
            switch ($count) {
                case 0:
                    $key .= '_zero';
                    break;

                case 1:
                    $key .= '_one';
                    break;

                default:
                    $key .= '_more';
                    break;
            }

            $message = sprintf(
                $this->trans($key, array(), 'lang', $this->locale),
                $count
            );
        } else {
            $message = $this->trans($key, array(), 'lang', $this->locale);
        }

        // Se la chiave e il messaggio corrispondono, significa che non c'è la traduzione
        if ($message === $key) {
            return Inflector::humanize($key);
        }

        return $message;
    }

    /**
     * Aggiunge le traduzioni dell'applicazione al servizio di traduzione
     *
     * @param $app_name
     * @param $culture
     */
    public function addApplicationTranslations($app_name, $culture)
    {
        $app_name = ucfirst($app_name);
        $culture = str_replace('_', '-', $culture);

        $file = PONGHO_PATH . '/Application/' . $app_name . '/Resources/translations/messages.' . $culture . '.xlf';

        if (file_exists($file)) {
            $this->addResource('xlffile', $file, $culture);
        }
    }
}
