<?php

namespace Application\Core\Form;

use Application\Admin\Form\SelectField;
use Application\Core\Model\Province;

class ProvinceField extends SelectField
{
	/**
	 * @inherits
	 */
	protected function setItems()
	{
		if ( $this->items === null )
		{
			$provinces = Province::all(array(
				'order'		=> 'name'
			));

			$this->items = array('');

			foreach ( $provinces as $province )
			{
				$this->items[$province->id] = $province->name;
			}
		}
	}
}
